
// caddg.h

# ifdef CADD_MAIN
#   define EXTERN
# else
#   define EXTERN extern
# endif // CADD_MAIN


// record definition

typedef struct tagMYREC
  {
    VBUFCB  VBufCB;

    char    name[51 + 1];        //  1 xref generated name key

    char    lastname[30 + 1];    //  2      last name
    char    firstname[20 + 1];   //  3      first name
    char    address[40 + 1];     //  4      address
    char    city[30 + 1];        //  5 xref city key
    char    state[2 + 1];        //  6 xref state
    char    zip[10 + 1];         //  7 xref zip code
    char    phone[20 + 1];       //  8 xref phone number
    VSTR    notes;               //  9      notes

  } MYREC;
typedef MYREC FAR * LPMYREC;

// standard format string for record

EXTERN char myrec_fmt[] = "X$*51,$*30,$*20,$*40,X$*30,X$*2,X$*10,X$*20,$";

// key length for record

EXTERN int  myrec_keylen = 10;

EXTERN HANDLE    hInst;            // hInstance of application


// function prototypes

int      PASCAL        WinMain(HANDLE hInstance,
                               HANDLE hPrevInstance,
                               LPSTR  lpszCmdLine,
                               int    cmdShow);

BOOL FAR PASCAL        AddressDlg(HWND hDlg,
                                  WORD message,
                                  WORD wParam,
                                  LONG lParam);

void                   show_record(HWND    hDlg,
                                   int     nDatasetNumber,
                                   LPSTR   lpkey,
                                   LPMYREC lpmyrec);

int                    build_record(HWND    hDlg,
                                    LPSTR   buf,
                                    WORD    lbuf,
                                    LPMYREC lpmyrec);

void                   clear_display(HWND hDlg);

int                    get_cur_index(HWND hDlg);

void                   save_wnd_pos(HWND  hWnd,
                                    LPSTR szIniFileName,
                                    LPSTR szIniSectionName,
                                    LPSTR szIniParmName);

void                   set_wnd_pos(HWND  hWnd,
                                   LPSTR szIniFileName,
                                   LPSTR szIniSectionName,
                                   LPSTR szIniParmName);

# undef EXTERN

// end caddg.h

